/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.UsuariosController;
import com.seguros.modelo.Usuarios;
import com.seguros.security.AuthenticatedUser;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.AgenciasView;
import com.seguros.vistas.AseguradorasView;
import com.seguros.vistas.AsesoresView;
import com.seguros.vistas.CarteraView;
import com.seguros.vistas.ClientesView;
import com.seguros.vistas.DatosmaestrosView;
import com.seguros.vistas.EstadosComisionView;
import com.seguros.vistas.EstadosPolizaView;
import com.seguros.vistas.InformesView;
import com.seguros.vistas.InicioView;
import com.seguros.vistas.MunicipiosView;
import com.seguros.vistas.PersonasView;
import com.seguros.vistas.PolizasView;
import com.seguros.vistas.PresupuestoView;
import com.seguros.vistas.ProduccionView;
import com.seguros.vistas.ProductosView;
import com.seguros.vistas.RamosView;
import com.seguros.vistas.TiposDocumentoView;
import com.seguros.vistas.TiposOperacionView;
import com.seguros.vistas.UsuariosView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.sidenav.SideNav;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class MainLayout
extends AppLayout {
    private H2 viewTitle;
    private AuthenticatedUser authenticatedUser;
    private AccessAnnotationChecker accessChecker;

    public MainLayout(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        String hashAlmacenado;
        String contrase\u00f1aProporcionada;
        BCryptPasswordEncoder encoder;
        this.authenticatedUser = authenticatedUser;
        this.accessChecker = accessChecker;
        Optional user = authenticatedUser.get();
        if (user.isPresent() && (encoder = new BCryptPasswordEncoder()).matches((CharSequence)(contrase\u00f1aProporcionada = "admin"), hashAlmacenado = ((Usuarios)user.get()).getPassword())) {
            Dialog changePasswordDialog = new Dialog();
            changePasswordDialog.setWidth("500px");
            changePasswordDialog.setHeight("400px");
            changePasswordDialog.setModal(true);
            FormLayout formLayout = new FormLayout();
            H2 titulo = new H2("Cambio de password");
            Span mensajeLabel = new Span("Se requiere cambio de contrase\u00f1a");
            mensajeLabel.getStyle().set("color", "blue");
            PasswordField newPasswordField = new PasswordField("Nueva Contrase\u00f1a");
            PasswordField confirmPasswordField = new PasswordField("Confirmar Contrase\u00f1a");
            Span errorLabel = new Span();
            errorLabel.getStyle().set("color", "red");
            Button acceptButton = new Button("Aceptar", (ComponentEventListener & Serializable)event -> {
                if (!newPasswordField.getValue().equals(confirmPasswordField.getValue())) {
                    errorLabel.setText("Los valores ingresados son diferentes");
                } else if (newPasswordField.getValue().equals("admin")) {
                    errorLabel.setText("El password debe ser diferente al password por defecto");
                } else if (newPasswordField.getValue().trim().isEmpty() || newPasswordField.getValue().trim().isBlank()) {
                    errorLabel.setText("El campo password no debe estar vacio");
                } else {
                    UsuariosController uc = new UsuariosController();
                    uc.cambiarPassword(((Usuarios)user.get()).getId(), newPasswordField.getValue());
                    errorLabel.setText("Password cambiado correctamente");
                    changePasswordDialog.close();
                    InicioApp.cargarUsuarios();
                }
            });
            formLayout.add(new Component[]{titulo, mensajeLabel, newPasswordField, confirmPasswordField, errorLabel});
            formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("25em", 1)});
            changePasswordDialog.setCloseOnEsc(false);
            changePasswordDialog.setCloseOnOutsideClick(false);
            changePasswordDialog.add(new Component[]{formLayout, new HorizontalLayout(new Component[]{acceptButton})});
            changePasswordDialog.open();
        }
        this.setPrimarySection(AppLayout.Section.DRAWER);
        this.addDrawerContent();
        this.addHeaderContent();
    }

    private void addHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.setAriaLabel("Menu toggle");
        FlexLayout layout = new FlexLayout();
        layout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.viewTitle = new H2();
        this.viewTitle.addClassNames(new String[]{"text-l", "m-0"});
        layout.setFlexGrow(1.0, new HasElement[]{this.viewTitle});
        Optional maybeUser = this.authenticatedUser.get();
        if (maybeUser.isPresent()) {
            Usuarios user = (Usuarios)maybeUser.get();
            Avatar avatar = new Avatar(user.getNombre());
            StreamResource resource = new StreamResource("profile-pic", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(user.getProfilePicture()));
            avatar.setImageResource((AbstractStreamResource)resource);
            avatar.setThemeName("xsmall");
            avatar.getElement().setAttribute("tabindex", "-1");
            MenuBar userMenu = new MenuBar();
            userMenu.setThemeName("tertiary-inline contrast");
            MenuItem userName = userMenu.addItem("");
            Div div = new Div();
            div.add(new Component[]{avatar});
            div.add(user.getUsuario());
            div.add(new Component[]{new Icon("lumo", "dropdown")});
            div.getElement().getStyle().set("display", "flex");
            div.getElement().getStyle().set("align-items", "center");
            div.getElement().getStyle().set("gap", "var(--lumo-space-s)");
            userName.add(new Component[]{div});
            ((SubMenu)userName.getSubMenu()).addItem("Sign out", (ComponentEventListener & Serializable)e -> this.authenticatedUser.logout());
            layout.add(new Component[]{userMenu});
        } else {
            Button loginButton = new Button("Iniciar Sesi\u00f3n");
            loginButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            loginButton.addClickListener((ComponentEventListener & Serializable)event -> this.getUI().ifPresent(ui -> ui.navigate("login")));
            layout.setAlignItems(FlexComponent.Alignment.END);
            layout.add(new Component[]{loginButton});
        }
        this.addToNavbar(true, new Component[]{toggle, this.viewTitle, layout});
    }

    private void addDrawerContent() {
        StreamResource imageResource = new StreamResource("logoMaxiseguros.jpg", (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream("/images/logoMaxiseguros.jpg"));
        Image image = new Image((AbstractStreamResource)imageResource, "inicio");
        image.setWidth("60px");
        H1 appName = new H1("Maxiseguros");
        appName.addClassNames(new String[]{"text-l", "m-0"});
        Header header = new Header(new Component[]{image, appName});
        Scroller scroller = new Scroller((Component)this.createNavigation());
        this.addToDrawer(new Component[]{header, scroller, this.createFooter()});
    }

    private SideNav createNavigation() {
        SideNav nav = new SideNav();
        if (this.accessChecker.hasAccess(InicioView.class)) {
            nav.addItem(new SideNavItem[]{new SideNavItem("Inicio", InicioView.class)});
        }
        if (this.accessChecker.hasAccess(ProduccionView.class)) {
            SideNavItem produccionMenu = new SideNavItem("Producci\u00f3n", ProduccionView.class);
            if (this.accessChecker.hasAccess(PolizasView.class)) {
                produccionMenu.addItem(new SideNavItem[]{new SideNavItem("P\u00f3lizas", PolizasView.class)});
            }
            if (this.accessChecker.hasAccess(CarteraView.class)) {
                produccionMenu.addItem(new SideNavItem[]{new SideNavItem("Cartera", CarteraView.class)});
            }
            if (this.accessChecker.hasAccess(PresupuestoView.class)) {
                produccionMenu.addItem(new SideNavItem[]{new SideNavItem("Presupuesto", PresupuestoView.class)});
            }
            nav.addItem(new SideNavItem[]{produccionMenu});
        }
        if (this.accessChecker.hasAccess(InformesView.class)) {
            SideNavItem informesMenu = new SideNavItem("Informes", InformesView.class);
            nav.addItem(new SideNavItem[]{informesMenu});
        }
        if (this.accessChecker.hasAccess(PersonasView.class)) {
            SideNavItem personasMenu = new SideNavItem("Personas", PersonasView.class);
            if (this.accessChecker.hasAccess(ClientesView.class)) {
                personasMenu.addItem(new SideNavItem[]{new SideNavItem("Clientes", ClientesView.class)});
            }
            if (this.accessChecker.hasAccess(AsesoresView.class)) {
                personasMenu.addItem(new SideNavItem[]{new SideNavItem("Asesores", AsesoresView.class)});
            }
            nav.addItem(new SideNavItem[]{personasMenu});
        }
        if (this.accessChecker.hasAccess(DatosmaestrosView.class)) {
            SideNavItem datosMaestrosMenu = new SideNavItem("Datos Maestros", DatosmaestrosView.class);
            if (this.accessChecker.hasAccess(TiposDocumentoView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Tipos de Documento", TiposDocumentoView.class)});
            }
            if (this.accessChecker.hasAccess(TiposOperacionView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Tipos de Operaci\u00f3n", TiposOperacionView.class)});
            }
            if (this.accessChecker.hasAccess(EstadosComisionView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Estados de Comisi\u00f3n", EstadosComisionView.class)});
            }
            if (this.accessChecker.hasAccess(EstadosPolizaView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Estados de P\u00f3liza", EstadosPolizaView.class)});
            }
            if (this.accessChecker.hasAccess(RamosView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Ramos", RamosView.class)});
            }
            if (this.accessChecker.hasAccess(ProductosView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Productos", ProductosView.class)});
            }
            if (this.accessChecker.hasAccess(AgenciasView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Agencias", AgenciasView.class)});
            }
            if (this.accessChecker.hasAccess(AseguradorasView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Aseguradoras", AseguradorasView.class)});
            }
            if (this.accessChecker.hasAccess(MunicipiosView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Municipios", MunicipiosView.class)});
            }
            if (this.accessChecker.hasAccess(UsuariosView.class)) {
                datosMaestrosMenu.addItem(new SideNavItem[]{new SideNavItem("Usuarios", UsuariosView.class)});
            }
            nav.addItem(new SideNavItem[]{datosMaestrosMenu});
        }
        return nav;
    }

    private Footer createFooter() {
        Footer layout = new Footer();
        return layout;
    }

    protected void afterNavigation() {
        super.afterNavigation();
        this.viewTitle.setText(this.getCurrentPageTitle());
    }

    private String getCurrentPageTitle() {
        PageTitle title = this.getContent().getClass().getAnnotation(PageTitle.class);
        return title == null ? "" : title.value();
    }
}

