/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.security.AuthenticatedUser;
import com.seguros.vistas.DatosmaestrosView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.InformesView;
import com.seguros.vistas.InicioViewCard;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.PersonasView;
import com.seguros.vistas.ProduccionView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.OrderedList;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import java.io.Serializable;

@PageTitle(value="Inicio")
@Route(value="inicio", layout=MainLayout.class)
@RouteAlias(value="", layout=MainLayout.class)
@AnonymousAllowed
public class InicioView
extends Main {
    private static final long serialVersionUID = 1L;
    private OrderedList imageContainer = new OrderedList();

    public InicioView(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        this.imageContainer.addClassNames(new String[]{"gap-m", "grid", "list-none", "m-0", "p-0"});
        InicioViewCard menuProduccion = new InicioViewCard("Producci\u00f3n", "/images/Produccion.png", "Producci\u00f3n", "abrir opciones de producci\u00f3n", "Gestione la informaci\u00f3n de la producci\u00f3n");
        InicioViewCard menuInformes = new InicioViewCard("Infomes", "/images/Informes.png", "Informes", "abrir opciones de informes", "Gestione los informes generados");
        InicioViewCard menuPersonas = new InicioViewCard("Personas", "/images/Personas.png", "Personas", "abrir opciones de personas", "Gestione la informaci\u00f3n de las personas (clientes y asesores)");
        InicioViewCard menuDatosMaestros = new InicioViewCard("Datos Maestros", "/images/DatosMaestros.png", "Datos Maestros", "abrir opciones de datos maestros", "Gestione la informaci\u00f3n de datos maestros");
        boolean esvacio = false;
        if (accessChecker.hasAccess(ProduccionView.class)) {
            this.imageContainer.add(new Component[]{menuProduccion});
            menuProduccion.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(ProduccionView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(InformesView.class)) {
            this.imageContainer.add(new Component[]{menuInformes});
            menuInformes.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(InformesView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(PersonasView.class)) {
            this.imageContainer.add(new Component[]{menuPersonas});
            menuPersonas.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(PersonasView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(DatosmaestrosView.class)) {
            this.imageContainer.add(new Component[]{menuDatosMaestros});
            menuDatosMaestros.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(DatosmaestrosView.class)));
            esvacio = true;
        }
        this.constructUI(esvacio);
    }

    private void constructUI(boolean elementos) {
        this.addClassNames(new String[]{"inicio-view"});
        this.addClassNames(new String[]{"max-w-screen-lg", "mx-auto", "pb-l", "px-l"});
        HorizontalLayout container = new HorizontalLayout();
        container.addClassNames(new String[]{"items-center", "justify-between"});
        VerticalLayout headerContainer = new VerticalLayout();
        if (elementos) {
            header = new H2("Men\u00fa Principal");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("Seleccione la opci\u00f3n deseada");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        } else {
            header = new H2("Bienvenido");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("Debe iniciar sesi\u00f3n para acceder a la aplicaci\u00f3n de gesti\u00f3n de corredores de seguros");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            StreamResource imageResource = new StreamResource("Imagen de inicio", (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream("/images/portada.jpg"));
            Image image = new Image();
            image.setWidth("100%");
            image.setSrc((AbstractStreamResource)imageResource);
            image.setAlt("Imagen de inicio");
            headerContainer.add(new Component[]{header, description, image});
        }
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        container.add(new Component[]{headerContainer});
        this.add(new Component[]{container, this.imageContainer, footerLayout});
    }
}

