/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.security.AuthenticatedUser;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.InformesViewCard;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.TableroProduccionView;
import com.seguros.vistas.TableroRenovacionesView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.OrderedList;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;

@PageTitle(value="Informes")
@Route(value="informes", layout=MainLayout.class)
@RolesAllowed(value={"USER"})
public class InformesView
extends Main
implements HasComponents,
HasStyle {
    private OrderedList imageContainer = new OrderedList();

    public InformesView(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        this.imageContainer.addClassNames(new String[]{"gap-m", "grid", "list-none", "m-0", "p-0"});
        boolean esvacio = false;
        if (accessChecker.hasAccess(TableroProduccionView.class)) {
            InformesViewCard menuTableroProduccion = new InformesViewCard("Tablero de producci\u00f3n", "/images/InformepowerBI1.png", "Tablero de producci\u00f3n", "Gestion de producci\u00f3n", "Analice la informaci\u00f3n de producci\u00f3n y seguimiento a la estrategia");
            this.imageContainer.add(new Component[]{menuTableroProduccion});
            menuTableroProduccion.addClickListener((ComponentEventListener & Serializable)e -> {
                Dialog dialog = new Dialog();
                dialog.setCloseOnEsc(false);
                dialog.setCloseOnOutsideClick(false);
                Span messageLabel = new Span("\u00bfEst\u00e1s seguro de que deseas abrir el informe?");
                Button confirmButton = new Button("S\u00ed", (ComponentEventListener & Serializable)event -> {
                    String powerBiEmbedUrl = "https://app.powerbi.com/reportEmbed?reportId=fc850fac-80b3-4f27-9c15-51744cb8b300&autoAuth=true&ctid=aa6bef17-dc01-402d-858a-3a8718a6ca6b";
                    UI.getCurrent().getPage().executeJs("window.open('" + powerBiEmbedUrl + "', '_blank');", new Serializable[0]);
                    dialog.close();
                });
                Button cancelButton = new Button("No", (ComponentEventListener & Serializable)event -> dialog.close());
                dialog.add(new Component[]{messageLabel, new HorizontalLayout(new Component[]{confirmButton, cancelButton})});
                dialog.open();
            });
            esvacio = true;
        }
        if (accessChecker.hasAccess(TableroRenovacionesView.class)) {
            InformesViewCard menuTableroRanovacion = new InformesViewCard("Tablero de renovaciones", "/images/Renovaciones.png", "Tablero de Renovaciones", "Gestion p\u00f3lizas pr\u00f3ximas a renovar", "Gestione las p\u00f3lizas que est\u00e1n pr\u00f3ximas a renovarse");
            this.imageContainer.add(new Component[]{menuTableroRanovacion});
            menuTableroRanovacion.addClickListener((ComponentEventListener & Serializable)e -> {
                Dialog dialog = new Dialog();
                dialog.setCloseOnEsc(false);
                dialog.setCloseOnOutsideClick(false);
                Span messageLabel = new Span("\u00bfEst\u00e1s seguro de que deseas abrir el informe?");
                Button confirmButton = new Button("S\u00ed", (ComponentEventListener & Serializable)event -> {
                    String powerBiEmbedUrl = "https://app.powerbi.com/reportEmbed?reportId=fc850fac-80b3-4f27-9c15-51744cb8b300&autoAuth=true&ctid=aa6bef17-dc01-402d-858a-3a8718a6ca6b";
                    UI.getCurrent().getPage().executeJs("window.open('" + powerBiEmbedUrl + "', '_blank');", new Serializable[0]);
                    dialog.close();
                });
                Button cancelButton = new Button("No", (ComponentEventListener & Serializable)event -> dialog.close());
                dialog.add(new Component[]{messageLabel, new HorizontalLayout(new Component[]{confirmButton, cancelButton})});
                dialog.open();
            });
            esvacio = true;
        }
        this.constructUI(esvacio);
    }

    private void constructUI(boolean elementos) {
        this.addClassNames(new String[]{"informes-view"});
        this.addClassNames(new String[]{"max-w-screen-lg", "mx-auto", "pb-l", "px-l"});
        HorizontalLayout container = new HorizontalLayout();
        container.addClassNames(new String[]{"items-center", "justify-between"});
        VerticalLayout headerContainer = new VerticalLayout();
        if (elementos) {
            header = new H2("Informes BI");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("Seleccione la opci\u00f3n deseada");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        } else {
            header = new H2("UPPS...HA OCURRIDO UN ERROR");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("NO TIENE ACCESO A ESTE MODULO");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        }
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        container.add(new Component[]{headerContainer});
        this.add(new Component[]{container, this.imageContainer, footerLayout});
    }
}

