/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.security.AuthenticatedUser;
import com.seguros.vistas.AgenciasView;
import com.seguros.vistas.AseguradorasView;
import com.seguros.vistas.EstadosComisionView;
import com.seguros.vistas.EstadosPolizaView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.InicioViewCard;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.MunicipiosView;
import com.seguros.vistas.ProductosView;
import com.seguros.vistas.RamosView;
import com.seguros.vistas.TiposDocumentoView;
import com.seguros.vistas.TiposOperacionView;
import com.seguros.vistas.UsuariosView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.OrderedList;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;

@PageTitle(value="Datosmaestros")
@Route(value="datosmaestros", layout=MainLayout.class)
@RolesAllowed(value={"DATOSMAESTROS", "ADMIN"})
public class DatosmaestrosView
extends Main
implements HasComponents,
HasStyle {
    private OrderedList imageContainer = new OrderedList();

    public DatosmaestrosView(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        this.imageContainer.addClassNames(new String[]{"gap-m", "grid", "list-none", "m-0", "p-0"});
        boolean esvacio = false;
        if (accessChecker.hasAccess(TiposDocumentoView.class)) {
            InicioViewCard menuTiposDocumento = new InicioViewCard("Tipos de documento", "/images/TipoDocumento.png", "Tipos de documento", "abrir opciones de tipos de documento", "Gestione la informaci\u00f3n maestra de tipos de documentos de los clientes");
            this.imageContainer.add(new Component[]{menuTiposDocumento});
            menuTiposDocumento.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(TiposDocumentoView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(TiposOperacionView.class)) {
            InicioViewCard menuTiposOperacion = new InicioViewCard("Tipos de operaci\u00f3n", "/images/TipoOperacion.png", "Tipos de operaci\u00f3n", "abrir opciones de tipos de operaci\u00f3n", "Gestione la informaci\u00f3n maestra de tipos de tipos de operaci\u00f3n sobre las p\u00f3lizas");
            this.imageContainer.add(new Component[]{menuTiposOperacion});
            menuTiposOperacion.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(TiposOperacionView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(EstadosPolizaView.class)) {
            InicioViewCard menuEstadosPoliza = new InicioViewCard("Estados de p\u00f3liza", "/images/EstadosPoliza.png", "Estados de la p\u00f3liza", "abrir opciones de estados de la p\u00f3liza", "Gestione la informaci\u00f3n maestra de los estados en que se puede encontrar una p\u00f3liza");
            this.imageContainer.add(new Component[]{menuEstadosPoliza});
            menuEstadosPoliza.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(EstadosPolizaView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(EstadosComisionView.class)) {
            InicioViewCard menuEstadosComision = new InicioViewCard("Estados de comisi\u00f3n", "/images/EstadosComision.png", "Estados de la comisi\u00f3n", "abrir opciones de estados de comisi\u00f3n", "Gestione la informaci\u00f3n maestra de los estados en que se puede encontrar una comisi\u00f3n");
            this.imageContainer.add(new Component[]{menuEstadosComision});
            menuEstadosComision.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(EstadosComisionView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(RamosView.class)) {
            InicioViewCard menuRamos = new InicioViewCard("Ramos", "/images/Ramos.png", "Ramos", "abrir opciones de ramos de productos", "Gestione la informaci\u00f3n maestra ramos a los que asocian los productos");
            this.imageContainer.add(new Component[]{menuRamos});
            menuRamos.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(RamosView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(ProductosView.class)) {
            InicioViewCard menuProductos = new InicioViewCard("Productos", "/images/Productos.png", "Productos", "abrir opciones de productos", "Gestione la informaci\u00f3n maestra de productos a los cuales pertenecen las p\u00f3lizas");
            this.imageContainer.add(new Component[]{menuProductos});
            menuProductos.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(ProductosView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(AgenciasView.class)) {
            InicioViewCard menuAgencias = new InicioViewCard("Agencias", "/images/Agencias.png", "Agencias", "abrir opciones agencias asociadas", "Gestione la informaci\u00f3n maestra de las agencias por medio de la que se expiden las p\u00f3lizas");
            this.imageContainer.add(new Component[]{menuAgencias});
            menuAgencias.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(AgenciasView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(AseguradorasView.class)) {
            InicioViewCard menuAseguradoras = new InicioViewCard("Aseguradoras", "/images/Aseguradoras.png", "Aseguradoras", "abrir opciones aseguradoras", "Gestione la informaci\u00f3n maestra de las aseguradoras");
            this.imageContainer.add(new Component[]{menuAseguradoras});
            menuAseguradoras.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(AseguradorasView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(MunicipiosView.class)) {
            InicioViewCard menuMunicipios = new InicioViewCard("Municipios", "/images/Municipios.png", "Municipios", "abrir opciones de municipios", "Gestione la informaci\u00f3n maestra de los municipios de colombia donde reside el cliente due\u00f1o de la p\u00f3liza");
            this.imageContainer.add(new Component[]{menuMunicipios});
            menuMunicipios.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(MunicipiosView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(UsuariosView.class)) {
            InicioViewCard menuUsuarios = new InicioViewCard("Usuarios", "/images/Clientes.png", "Usuarios", "Administrar informaci\u00f3n de usuarios y roles", "Gestione la informaci\u00f3n de usuarios de aplicaci\u00f3n, informaci\u00f3n b\u00e1sica, roles y accesos");
            this.imageContainer.add(new Component[]{menuUsuarios});
            menuUsuarios.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(UsuariosView.class)));
            esvacio = true;
        }
        this.constructUI(esvacio);
    }

    private void constructUI(boolean elementos) {
        this.addClassNames(new String[]{"datosmaestros-view"});
        this.addClassNames(new String[]{"max-w-screen-lg", "mx-auto", "pb-l", "px-l"});
        HorizontalLayout container = new HorizontalLayout();
        container.addClassNames(new String[]{"items-center", "justify-between"});
        VerticalLayout headerContainer = new VerticalLayout();
        if (elementos) {
            header = new H2("Datos Maestros");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("seleccione la opci\u00f3n deseada");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        } else {
            header = new H2("UPPS...HA OCURRIDO UN ERROR");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("NO TIENE ACCESO A ESTE MODULO");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        }
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        container.add(new Component[]{headerContainer});
        this.add(new Component[]{container, this.imageContainer, footerLayout});
    }
}

