/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.ClientesController;
import com.seguros.modelo.Clientes;
import com.seguros.vistas.ClientesView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@PageTitle(value="Personas -> Clientes")
@Route(value="clientes", layout=MainLayout.class)
@RolesAllowed(value={"CLIENTES", "ADMIN"})
public class ClientesView
extends Div {
    private ClientesController controller = new ClientesController();
    private final Grid<Clientes> grid = new Grid(Clientes.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button deleteButton = new Button("Eliminar");

    public ClientesView() {
        this.configureGrid();
        H3 title = new H3("CLIENTES");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione los clientes de p\u00f3liza");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.editButton.setIcon((Component)new Icon(VaadinIcon.PENCIL));
        this.deleteButton.setIcon((Component)new Icon(VaadinIcon.TRASH));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Clientes()));
        this.editButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Clientes selected = (Clientes)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showEditDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a editar");
            }
        });
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Clientes selected = (Clientes)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showDeleteDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a eliminar");
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.editButton, this.deleteButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "numerodocumento", "nombrecompleto", "numerocontacto", "email", "direccion", "fechanacimiento"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("numerodocumento").setHeader("NUMERODOCUMENTO");
        this.grid.getColumnByKey("nombrecompleto").setHeader("NOMBRECOMPLETO");
        this.grid.getColumnByKey("numerocontacto").setHeader("NUMEROCONTACTO");
        this.grid.getColumnByKey("email").setHeader("EMAIL");
        this.grid.getColumnByKey("direccion").setHeader("DIRECCION");
        this.grid.getColumnByKey("fechanacimiento").setHeader("FECHA DE NACIMIENTO");
        this.updateList("");
        this.grid.addColumn((ValueProvider & Serializable)cliente -> cliente.getTipoDocumento() != null ? cliente.getTipoDocumento().getCodigo() + " - " + cliente.getTipoDocumento().getDescripcion() : "").setHeader("TIPO DOCUMENTO").setKey("tiposdocumentoDescripcion");
        this.grid.addColumn((ValueProvider & Serializable)cliente -> cliente.getMunicipio() != null ? cliente.getMunicipio().getNombreciudad() + " - " + cliente.getMunicipio().getNombredepartamento() : "").setHeader("MUNICIPIO").setKey("municipiosNombreciudad");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
    }

    private void updateList(String value) {
        List clientes = this.getFilteredClientes(value);
        this.grid.setItems((Collection)clientes);
    }

    private List<Clientes> getFilteredClientes(String filterValue) {
        List clientes = this.controller.getAllClientes();
        if (filterValue == null || filterValue.isEmpty()) {
            return clientes;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return clientes.stream().filter(t -> t.getNumerodocumento() != null && t.getNumerodocumento().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getNombrecompleto() != null && t.getNombrecompleto().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getNumerocontacto() != null && t.getNumerocontacto().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEmail() != null && t.getEmail().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getDireccion() != null && t.getDireccion().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getMunicipio() != null && t.getMunicipio().getNombreciudad().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Clientes clientes) {
        EditDialog dialog = new EditDialog(this, clientes);
        dialog.open();
    }

    private void showDeleteDialog(Clientes clientes) {
        Dialog dialog = new Dialog();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.add("\u00bfEst\u00e1s seguro de que quieres eliminar este registro?");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button deleteButton = new Button("Eliminar", (ComponentEventListener & Serializable)event -> {
            this.controller.deleteClientes(clientes.getId().intValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{deleteButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        verticalLayout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{verticalLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

