/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.AgenciasController;
import com.seguros.modelo.Agencias;
import com.seguros.vistas.AgenciasView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@PageTitle(value="Datos Maestros -> Agencias")
@Route(value="agencias", layout=MainLayout.class)
@RolesAllowed(value={"AGENCIAS", "ADMIN"})
public class AgenciasView
extends Div {
    private AgenciasController controller = new AgenciasController();
    private final Grid<Agencias> grid = new Grid(Agencias.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button deleteButton = new Button("Eliminar");

    public AgenciasView() {
        this.configureGrid();
        H3 title = new H3("AGENCIAS");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione las agencias por medio las cuales se pueden expedir p\u00f3lizas");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.editButton.setIcon((Component)new Icon(VaadinIcon.PENCIL));
        this.deleteButton.setIcon((Component)new Icon(VaadinIcon.TRASH));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Agencias()));
        this.editButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Agencias selected = (Agencias)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showEditDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a editar");
            }
        });
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Agencias selected = (Agencias)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showDeleteDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a eliminar");
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.editButton, this.deleteButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        footerLayout.setWidthFull();
        footerLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        footerLayout.getStyle().set("margin-top", "2em");
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "nombre", "contacto", "telefono", "email"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("nombre").setHeader("NOMBRE");
        this.grid.getColumnByKey("contacto").setHeader("CONTACTO");
        this.grid.getColumnByKey("telefono").setHeader("TELEFONO");
        this.grid.getColumnByKey("email").setHeader("EMAIL");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
        this.updateList("");
    }

    private void updateList(String value) {
        List agencias = this.getFilteredAgencias(value);
        this.grid.setItems((Collection)agencias);
    }

    private List<Agencias> getFilteredAgencias(String filterValue) {
        List agencias = this.controller.getAllAgencias();
        if (filterValue == null || filterValue.isEmpty()) {
            return agencias;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return agencias.stream().filter(t -> t.getNombre() != null && t.getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getContacto() != null && t.getContacto().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEmail() != null && t.getEmail().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getTelefono() != null && t.getTelefono().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Agencias agencias) {
        EditDialog dialog = new EditDialog(this, agencias);
        dialog.open();
    }

    private void showDeleteDialog(Agencias agencias) {
        Dialog dialog = new Dialog();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.add("\u00bfEst\u00e1s seguro de que quieres eliminar este registro?");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button deleteButton = new Button("Eliminar", (ComponentEventListener & Serializable)event -> {
            this.controller.deleteAgencias(agencias.getId().intValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{deleteButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        verticalLayout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{verticalLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

