/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.seguros.modelo.Usuarios;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.UsuariosView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/Usuarios"})
public class UsuariosController {
    @Value(value="${usuarioApi}")
    private String usuarioApi;
    @Value(value="${passwordApi}")
    private String passwordApi;
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "usuarios";

    @GetMapping(value={"/usuarios"})
    public ModelAndView navigateToUsuariosView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Usuarios> getAllUsuarios() {
        return InicioApp.getLusuarios();
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateUsuarios(Usuarios usuarios) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(usuarios);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (usuarios.getId() == null) {
                    usuarios.setFechaactualizacion(currentDate.toString());
                    usuarios.setUsuarioactualizacion(userName);
                    usuarios.setFechacreacion(currentDate.toString());
                    usuarios.setUsuariocreacion(userName);
                } else {
                    usuarios.setFechaactualizacion(currentDate.toString());
                    usuarios.setUsuarioactualizacion(userName);
                }
                String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                byte[] authHeaderBytes = authHeader.getBytes();
                String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", encodedAuthHeader);
                HttpEntity requestEntity = new HttpEntity((Object)usuarios, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                InicioApp.cargarUsuarios();
                UsuariosView.showNotification((String)"Dato almacenado correctamente", (boolean)false);
                return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
            }
            catch (Exception e) {
                UsuariosView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    @DeleteMapping(value={"/{id}"})
    public void reinicarpaswordUsuarios(@PathVariable int id) {
        Usuarios usuarioActual = new Usuarios();
        for (Usuarios u : InicioApp.getLusuarios()) {
            if (u.getId() != id) continue;
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            String contrase\u00f1aEncriptada = encoder.encode((CharSequence)"admin");
            u.setPassword(contrase\u00f1aEncriptada);
            usuarioActual = u;
            break;
        }
        this.createOrUpdateUsuarios(usuarioActual);
    }

    private StringBuilder validarDatos(Usuarios usuario) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)usuario, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                UsuariosView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }

    public void cambiarPassword(Integer id, String password) {
        Usuarios usuarioActual = new Usuarios();
        for (Usuarios u : InicioApp.getLusuarios()) {
            if (u.getId() != id) continue;
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            String contrase\u00f1aEncriptada = encoder.encode((CharSequence)password);
            u.setPassword(contrase\u00f1aEncriptada);
            usuarioActual = u;
            break;
        }
        this.createOrUpdateUsuarios(usuarioActual);
    }
}

