/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.poiji.annotation.ExcelCellName;
import com.poiji.bind.Poiji;
import com.seguros.modelo.Presupuesto;
import com.seguros.utilitarios.ExcelPresupuesto;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.CarteraView;
import com.seguros.vistas.PresupuestoView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/Presupuesto"})
public class PresupuestoController {
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "presupuesto";

    @GetMapping(value={"/presupuesto"})
    public ModelAndView navigateToPresupuestoView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Presupuesto> getAllPresupuesto() {
        return InicioApp.getLpresupuesto();
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdatePresupuesto(Presupuesto presupuesto) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(presupuesto);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (presupuesto.getId() == null) {
                    presupuesto.setFechaactualizacion(currentDate.toString());
                    presupuesto.setUsuarioactualizacion(userName);
                    presupuesto.setFechacreacion(currentDate.toString());
                    presupuesto.setUsuariocreacion(userName);
                } else {
                    presupuesto.setFechaactualizacion(currentDate.toString());
                    presupuesto.setUsuarioactualizacion(userName);
                }
                String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                byte[] authHeaderBytes = authHeader.getBytes();
                String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", encodedAuthHeader);
                HttpEntity requestEntity = new HttpEntity((Object)presupuesto, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                InicioApp.cargarPresupuesto();
                return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
            }
            catch (Exception e) {
                PresupuestoView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    private List<String> validarEncabezados(Row headerRow, Class<ExcelPresupuesto> excelPresupuestoClass) {
        ArrayList<String> encabezadosEsperados = new ArrayList<String>();
        for (Field field : excelPresupuestoClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelCellName.class)) continue;
            ExcelCellName annotation = field.getAnnotation(ExcelCellName.class);
            encabezadosEsperados.add(annotation.value());
        }
        for (Cell cell : headerRow) {
            if (cell == null || !encabezadosEsperados.contains(cell.getStringCellValue())) continue;
            encabezadosEsperados.remove(cell.getStringCellValue());
        }
        return encabezadosEsperados;
    }

    @DeleteMapping(value={"/{id}"})
    public void deletePresupuesto(@PathVariable int id, String operacion) {
        RestTemplate restTemplate = new RestTemplate();
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.baseUrl + "/" + id, HttpMethod.DELETE, entity, String.class, new Object[0]);
        if (operacion.equalsIgnoreCase("DELETE")) {
            InicioApp.cargarPresupuesto();
        }
    }

    private StringBuilder validarDatos(Presupuesto tipodocumento) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)tipodocumento, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                PresupuestoView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }

    public String createOrUpdatePresupuesto(byte[] excel) throws IOException, InvalidFormatException {
        try {
            boolean datosvalidos = true;
            File excelFile = PresupuestoController.convertirBytesAFile((byte[])excel);
            if (excelFile == null) {
                System.out.println("Error al convertir byte[] a File.");
                return "Error al procesar el archivo, valide el formato";
            }
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            Sheet sheet = workbook.getSheet("PRESUPUESTO");
            if (sheet == null) {
                CarteraView.showNotification((String)"La hoja 'PRESUPUESTO' no existe en el archivo.", (boolean)true);
                return "La hoja 'PRESUPUESTO' no existe en el archivo.";
            }
            Row headerRow = sheet.getRow(sheet.getFirstRowNum());
            List camposfaltantes = this.validarEncabezados(headerRow, ExcelPresupuesto.class);
            if (!camposfaltantes.isEmpty()) {
                Object mensaje = "";
                if (camposfaltantes.size() == 1) {
                    mensaje = "Falta la columna:" + (String)camposfaltantes.get(0) + " en el archivo:";
                } else {
                    mensaje = "Faltan las columnas: ";
                    for (String campo : camposfaltantes) {
                        mensaje = (String)mensaje + campo + ", ";
                    }
                    mensaje = ((String)mensaje).substring(0, ((String)mensaje).length() - 2);
                    mensaje = (String)mensaje + " en el archivo";
                }
                CarteraView.showNotification((String)mensaje, (boolean)true);
                return mensaje;
            }
            List presupuestoExcel = Poiji.fromExcel((File)excelFile, ExcelPresupuesto.class);
            ArrayList<Presupuesto> presupuestoNueva = new ArrayList<Presupuesto>();
            ArrayList<CallSite> errores = new ArrayList<CallSite>();
            int fila = 2;
            for (ExcelPresupuesto e : presupuestoExcel) {
                System.out.println(e.toString());
                Presupuesto presupuesto = new Presupuesto();
                if (e.getAnio() == null || e.getAnio().isEmpty()) {
                    errores.add((CallSite)((Object)("Error al procesar la fila " + fila + " el campo A\u00d1O esta vacio")));
                } else {
                    try {
                        presupuesto.setAnio(Integer.valueOf(e.getAnio()));
                        if (presupuesto.getAnio() < 2000 || presupuesto.getAnio() > 2100) {
                            errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo A\u00d1O:" + e.getAnio())));
                            datosvalidos = false;
                        }
                    }
                    catch (NumberFormatException nfeAnio) {
                        errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo A\u00d1O:" + e.getAnio())));
                        datosvalidos = false;
                    }
                }
                if (e.getMes() == null || e.getMes().isEmpty()) {
                    errores.add((CallSite)((Object)("Error al procesar la fila " + fila + " el campo MES esta vacio")));
                } else {
                    try {
                        presupuesto.setMes(Integer.valueOf(e.getMes()));
                        if (Integer.parseInt(e.getMes()) < 10) {
                            presupuesto.setPeriodo(e.getAnio() + "0" + e.getMes());
                        } else {
                            presupuesto.setPeriodo(e.getAnio() + e.getMes());
                        }
                        if (presupuesto.getMes() < 1 || presupuesto.getMes() > 12) {
                            errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo MES:" + e.getMes())));
                            datosvalidos = false;
                        }
                    }
                    catch (NumberFormatException nfeMes) {
                        errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo MES: " + e.getMes())));
                        datosvalidos = false;
                    }
                }
                e.setComision(e.getComision() != null ? e.getComision().replace(",", "").replace("$", "") : "0");
                e.setPrima(e.getPrima() != null ? e.getPrima().replace(",", "").replace("$", "") : "0");
                e.setNegocios(e.getComision() != null ? e.getNegocios() : "0");
                try {
                    presupuesto.setPrima(Double.valueOf(e.getPrima().replace(",", "").replace("$", "") != null ? Double.valueOf(e.getPrima().replace(",", "").replace("$", "")) : 0.0));
                }
                catch (NumberFormatException nfePrima) {
                    errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo PRIMA: " + e.getPrima())));
                    System.err.println("Error al procesar en la fila " + fila + " el campo PRIMA: " + e.getPrima());
                    datosvalidos = false;
                }
                try {
                    presupuesto.setComision(Double.valueOf(e.getComision().replace(",", "").replace("$", "") != null ? Double.valueOf(e.getComision().replace(",", "").replace("$", "")) : 0.0));
                }
                catch (NumberFormatException nfeComision) {
                    errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo COMISION: " + e.getComision())));
                    datosvalidos = false;
                }
                try {
                    presupuesto.setNegocios(Double.valueOf(e.getNegocios() != null ? Double.valueOf(e.getNegocios()) : 0.0));
                }
                catch (NumberFormatException nfeNegocios) {
                    errores.add((CallSite)((Object)("Error al procesar en la fila " + fila + " el campo NEGOCIOS: " + e.getNegocios())));
                    datosvalidos = false;
                }
                presupuestoNueva.add(presupuesto);
                ++fila;
            }
            if (datosvalidos) {
                HashSet<Integer> periodosUnicos = new HashSet<Integer>();
                for (Presupuesto presupuesto : presupuestoNueva) {
                    periodosUnicos.add(presupuesto.getAnio());
                }
                for (Presupuesto presupuesto : InicioApp.getLpresupuesto()) {
                    Iterator iterator = periodosUnicos.iterator();
                    while (iterator.hasNext()) {
                        int periodo = (Integer)iterator.next();
                        if (presupuesto.getAnio() != periodo) continue;
                        this.deletePresupuesto(presupuesto.getId().intValue(), "RELOAD");
                    }
                }
                for (Presupuesto presupuesto : presupuestoNueva) {
                    this.createOrUpdatePresupuesto(presupuesto);
                }
                PresupuestoView.showNotification((String)"Archivo Cargado Exitosamente", (boolean)false);
                return "0";
            }
            Object mensaje = "";
            for (String string : errores) {
                mensaje = (String)mensaje + "\n" + string;
                System.out.println(string);
            }
            return mensaje;
        }
        catch (IOException e) {
            System.err.println("Error al abrir el archivo Excel: " + e.getMessage());
            CarteraView.showNotification((String)"Error al abrir el archivo Excel, revise el formato", (boolean)true);
            return "Error";
        }
    }

    private static File convertirBytesAFile(byte[] bytes) {
        try {
            File file = File.createTempFile("temp", ".xlsx");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void EliminarPresupuesto(String periodo) {
        for (Presupuesto p : InicioApp.getLpresupuesto()) {
            int per = Integer.parseInt(periodo);
            if (p.getAnio() != per) continue;
            this.deletePresupuesto(p.getId().intValue(), "DELETE");
        }
        PresupuestoView.showNotification((String)"Datos Eliminados Exitosamente", (boolean)false);
    }
}

