/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.poiji.annotation.ExcelCellName;
import com.poiji.bind.Poiji;
import com.seguros.modelo.Cartera;
import com.seguros.utilitarios.ExcelCartera;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.CarteraView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/Cartera"})
public class CarteraController {
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "cartera";

    @GetMapping(value={"/cartera"})
    public ModelAndView navigateToCarteraView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Cartera> getAllCartera() {
        return InicioApp.getLcartera();
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateCartera(Cartera cartera) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(cartera);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (cartera.getId() == null) {
                    cartera.setFechaactualizacion(currentDate.toString());
                    cartera.setUsuarioactualizacion(userName);
                    cartera.setFechacreacion(currentDate.toString());
                    cartera.setUsuariocreacion(userName);
                } else {
                    cartera.setFechaactualizacion(currentDate.toString());
                    cartera.setUsuarioactualizacion(userName);
                }
                String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                byte[] authHeaderBytes = authHeader.getBytes();
                String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", encodedAuthHeader);
                HttpEntity requestEntity = new HttpEntity((Object)cartera, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                InicioApp.cargarCartera();
                return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
            }
            catch (Exception e) {
                CarteraView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteCartera(@PathVariable int id, String operacion) {
        RestTemplate restTemplate = new RestTemplate();
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.baseUrl + "/" + id, HttpMethod.DELETE, entity, String.class, new Object[0]);
        if (operacion.equals("DELETE")) {
            InicioApp.cargarCartera();
        }
    }

    private StringBuilder validarDatos(Cartera tipodocumento) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)tipodocumento, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                CarteraView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }

    public void EliminarCartera(String periodo, String financiera) {
        for (Cartera c : InicioApp.getLcartera()) {
            if (!c.getPeriodo().equalsIgnoreCase(periodo) || !c.getFinanciadora().equalsIgnoreCase(financiera)) continue;
            this.deleteCartera(c.getId().intValue(), "DELETE");
        }
        CarteraView.showNotification((String)"Datos Eliminados Exitosamente", (boolean)false);
    }

    public String createOrUpdateCartera(String periodo, String financiera, byte[] excel) throws InvalidFormatException, IOException {
        try {
            boolean datosvalidos = true;
            File excelFile = CarteraController.convertirBytesAFile((byte[])excel);
            if (excelFile == null) {
                System.out.println("Error al convertir byte[] a File.");
                return "Error al procesar el archivo, valide el formato";
            }
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            Sheet sheet = workbook.getSheet("CARTERA");
            if (sheet == null) {
                CarteraView.showNotification((String)"La hoja 'CARTERA' no existe en el archivo.", (boolean)true);
                return "La hoja 'CARTERA' no existe en el archivo.";
            }
            Row headerRow = sheet.getRow(sheet.getFirstRowNum());
            List camposfaltantes = this.validarEncabezados(headerRow, ExcelCartera.class);
            if (!camposfaltantes.isEmpty()) {
                Object mensaje = "";
                if (camposfaltantes.size() == 1) {
                    mensaje = "Falta la columna:" + (String)camposfaltantes.get(0) + " en el archivo:";
                } else {
                    mensaje = "Faltan las columnas: ";
                    for (String campo : camposfaltantes) {
                        mensaje = (String)mensaje + campo + ", ";
                    }
                    mensaje = ((String)mensaje).substring(0, ((String)mensaje).length() - 2);
                    mensaje = (String)mensaje + " en el archivo";
                }
                CarteraView.showNotification((String)mensaje, (boolean)true);
                return mensaje;
            }
            List carteraExcel = Poiji.fromExcel((File)excelFile, ExcelCartera.class);
            ArrayList<Cartera> carteraNueva = new ArrayList<Cartera>();
            ArrayList<Object> errores = new ArrayList<Object>();
            if (financiera == null || financiera.isEmpty()) {
                errores.add("No es posible realizar la carga, debe diligenciar el campo FINANCIERA");
                datosvalidos = false;
            }
            if (periodo == null || periodo.isEmpty()) {
                errores.add("No es posible realizar la carga, debe diligenciar el campo PERIODO");
                datosvalidos = false;
            }
            int fila = 2;
            for (ExcelCartera e : carteraExcel) {
                System.out.println(e.toString());
                Cartera cartera = new Cartera();
                cartera.setFinanciadora(financiera);
                cartera.setPeriodo(periodo);
                if (e.getCredito() == null || e.getCredito().isEmpty()) {
                    errores.add("Error al procesar la fila " + fila + " el campo CREDITO esta vacio");
                    datosvalidos = false;
                } else {
                    cartera.setCredito(e.getCredito());
                }
                if (e.getPoliza() == null || e.getPoliza().isEmpty()) {
                    errores.add("Error al procesar la fila " + fila + " el campo POLIZA esta vacio");
                    datosvalidos = false;
                } else {
                    cartera.setPoliza(e.getPoliza());
                }
                if (e.getEstado() == null || e.getEstado().isEmpty()) {
                    errores.add("Error al procesar la fila " + fila + " el campo ESTADO esta vacio");
                    datosvalidos = false;
                } else {
                    cartera.setEstado(e.getEstado());
                }
                try {
                    e.setDiasMora(e.getDiasMora() != null ? e.getDiasMora() : "0");
                    cartera.setDiasMora(Integer.valueOf(e.getDiasMora() != null ? Integer.valueOf(e.getDiasMora()) : 0));
                    if (cartera.getDiasMora() < 0) {
                        errores.add("Error al procesar en la fila " + fila + " el campo DIAS DE MORA: " + e.getDiasMora());
                        datosvalidos = false;
                    }
                }
                catch (NumberFormatException nfeNegocios) {
                    errores.add("Error al procesar en la fila " + fila + " el campo DIAS DE MORA: " + e.getDiasMora());
                    datosvalidos = false;
                }
                carteraNueva.add(cartera);
                ++fila;
            }
            if (datosvalidos) {
                HashSet<String> periodosUnicos = new HashSet<String>();
                for (Cartera cartera : carteraNueva) {
                    periodosUnicos.add(cartera.getPeriodo());
                }
                for (Cartera cartera : InicioApp.getLcartera()) {
                    for (String periodoact : periodosUnicos) {
                        if (cartera.getPeriodo() != periodoact) continue;
                        this.deleteCartera(cartera.getId().intValue(), "RELOAD");
                    }
                }
                for (Cartera cartera : carteraNueva) {
                    this.createOrUpdateCartera(cartera);
                }
                CarteraView.showNotification((String)"Archivo Cargado Exitosamente", (boolean)false);
                return "0";
            }
            Object mensaje = "";
            for (String string : errores) {
                mensaje = (String)mensaje + "\n" + string;
                System.out.println(string);
            }
            return mensaje;
        }
        catch (IOException e) {
            System.err.println("Error al abrir el archivo Excel: " + e.getMessage());
            CarteraView.showNotification((String)"Error al abrir el archivo Excel, revise el formato", (boolean)true);
            return "Error";
        }
    }

    private static File convertirBytesAFile(byte[] bytes) {
        try {
            File file = File.createTempFile("temp", ".xlsx");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> validarEncabezados(Row headerRow, Class<ExcelCartera> excelCarteraClass) {
        ArrayList<String> encabezadosEsperados = new ArrayList<String>();
        for (Field field : excelCarteraClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelCellName.class)) continue;
            ExcelCellName annotation = field.getAnnotation(ExcelCellName.class);
            encabezadosEsperados.add(annotation.value());
        }
        for (Cell cell : headerRow) {
            if (cell == null || !encabezadosEsperados.contains(cell.getStringCellValue())) continue;
            encabezadosEsperados.remove(cell.getStringCellValue());
        }
        return encabezadosEsperados;
    }
}

